<?php

namespace Barn2\Plugin\Posts_Table_Pro\Admin;

use Barn2\PTP_Lib\Util as Lib_Util,
	Barn2\PTP_Lib\Plugin\Plugin_Activation_Listener,
	Barn2\PTP_Lib\Plugin\Licensed_Plugin,
	Barn2\PTP_Lib\Registerable;

/**
 * Plugin Setup
 *
 * @package   Barn2/posts-table-pro
 * @author    Barn2 Plugins <info@barn2.com>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
class Plugin_Setup implements Plugin_Activation_Listener, Registerable {

	private $plugin;

	/**
	 * Constructor.
	 *
	 * @param mixed $file
	 * @param Licensed_Plugin $plugin
	 */
	public function __construct( Licensed_Plugin $plugin ) {
		$this->plugin = $plugin;
	}

	/**
	 * {@inheritdoc}
	 */
	public function register() {
		register_activation_hook( $this->plugin->get_file(), [ $this, 'on_activate' ] );
	}

	/**
	 * On plugin activation
	 */
	public function on_activate() {
        $this->create_search_results_page();
	}

	/**
	 * On plugin deactivation.
	 */
	public function on_deactivate() {}

    /**
     * Creates the search results page.
     */
    private function create_search_results_page() {
		$search_results_page_id = get_option( 'ptp_search_page' );

		if ( $search_results_page_id === false || get_post_status( (int) $search_results_page_id ) !== 'publish' ) {
			Lib_Util::create_page(
				_x( 'posts-search', 'Page slug', 'posts-table-pro' ),
				'ptp_search_page',
				_x( 'Search', 'Page title', 'posts-table-pro' )
			);
		}
    }
}
